#include <stdio.h>
#include <stdlib.h>
#include <unordered_map>
#include <vector>
using namespace std;

struct Point {
    int x, y;
};

int main() {
    int n;
    scanf("%d", &n);
    vector<Point> pts(n);
    for (int i = 0; i < n; i++) scanf("%d %d", &pts[i].x, &pts[i].y);

    long long greetings = 0;

    unordered_map<long long, vector<int>> byY; 
    unordered_map<long long, vector<int>> byX; 

    for (int i = 0; i < n; i++) {
        byY[pts[i].y].push_back(pts[i].x);
        byX[pts[i].x].push_back(pts[i].y);
    }

    for (int i = 0; i < n; i++) {
        for (int j = i+1; j < n; j++) {
            int x1 = pts[i].x, y1 = pts[i].y;
            int x2 = pts[j].x, y2 = pts[j].y;
            int t1 = x2 - x1;
            if (t1 >= 0 && y1 == y2 - t1) greetings++;
            int t2 = x1 - x2;
            if (t2 >= 0 && y2 == y1 - t2) greetings++;
        }
    }

    for (auto &kv : byY) {
        auto &xs = kv.second;
        for (size_t i = 0; i < xs.size(); i++) {
            for (size_t j = i+1; j < xs.size(); j++) {
                int diff = xs[j] - xs[i];
                if (diff % 2 == 0) greetings++;
            }
        }
    }

    for (auto &kv : byX) {
        auto &ys = kv.second;
        for (size_t i = 0; i < ys.size(); i++) {
            for (size_t j = i+1; j < ys.size(); j++) {
                int diff = ys[j] - ys[i];
                if (diff % 2 == 0) greetings++;
            }
        }
    }

    printf("%lld\n", greetings);
    return 0;
}